<?php
/**
 * DuoLamPHP FrameWork 
 * http://www.imoi.cn
 *
 * Copyright (c) 2011 Mo Yi
 * 
 * @author Mo Yi root@imoi.cn
 */
 
 !defined('DL_Root') && exit ( 'Access Denied!' );

 class DTemplate extends DuoLamBase{

	/**
	 * 模板变量
	 * @var array
	 */
	private $_var;

	/**
	 * 前台模板调用
	 * @param string $tpl_name;		//模板文件名
	 */
	public function display($tpl_name){
		if(empty($tpl_name)) return 0;
		//模板文件
		$_tplFile = APP_PATH. 'Views' . DS . str_replace('-','/',$tpl_name) . '.html';
		//缓存目录
		$_cacheDir = APP_PATH. 'Cache' . DS . 'Tpl' .DS;
		//缓存文件
		$_cacheFile = $_cacheDir . str_replace('-','/',$tpl_name) . '.php';
		is_dir($_cacheDir) or @mkdir($_cacheDir);
		is_writable($_cacheDir) or DEr::notice('模板缓存目录不可写，请手动修改！');
		is_file($_tplFile) or DEr::notice('出错了！模板不存在！文件：' . $_tplFile);
		if(is_file($_cacheFile)){
			if(filemtime($_cacheFile) == filemtime($_tplFile)){
				!empty($this->_var) && @extract($this->_var);
				require_once $_cacheFile;
			}else{
				unlink($_cacheFile);
				$this->setdir($_cacheDir . $tpl_name);
				$this->cache($_cacheFile,$_tplFile);
			}
		}else{
			$this->setdir($_cacheDir . $tpl_name);
			$this->cache($_cacheFile,$_tplFile);
		}
	}
	

	public function cache($_cacheFile,$_tplFile){
		$content = file_get_contents($_tplFile);
		$content = $this->complie($content);
		file_put_contents($_cacheFile,$content);
		@touch($_cacheFile,filemtime($_tplFile));
		!empty($this->_var) && @extract($this->_var);
		require_once $_cacheFile;
	}
	/**
	 * 模版注入变量
	 * @param string or array 		变量名
	 * @param string $value		变量值
	 */
	public function assign($var,$value=''){
		if(is_array($var)){
			foreach($var as $v => $k){
				$this->_var[$v] = $k;
			}
		}else{
			$this->_var[$var] = $value;
		}
	}

	public function runtime($query){
		return 'Process In '.substr(microtime(true) - DuoLamBase::$config['frame']['time'],0,5).'s , '.$query.' Queries ' . DuoLam;
	}

	private function setdir($param){
		if(stripos($param, '-') === false){
				return 0;
		}else{
			$dir = explode('-',$param);
			is_dir($dir[0]) or mkdir($dir[0]);
		}
	}

	private function complie($content){
		$temp = DuoLamBase::$config['frame']['mode']==2 ? '<?=DuoLam::url()?>' : '<?=DuoLam::url()."index.php/"?>';
		$strArray = array(
			'/{include:(.*?)}/i',
			'/{view}/i',
			'/{path}/i',
			'/{url}/i',
			'/{jc:(.*?)}/i',
		);
		$relayArray = array(
			'<? $this->display("\\1"); ?>',
			'<?=DuoLam::uview(); ?>',
			'<?=DuoLam::url()?>',
			$temp,
			'<?=$this->Jc("\\1"); ?>',
		);
		return preg_replace($strArray,$relayArray,$content);
	}

	private function Jc($file){
		$dir =  DuoLam::ucache().'Tpl/'.str_replace('-','/',$file);
		$dir2= APP_PATH . 'Cache'.DS.'Tpl'.DS;
		$this->setdir($dir2.$file);
		$file = str_replace('-','/',$file);
		$filepath = APP_PATH . 'Views'. DS .$file;
		if(!is_file($dir2.$file)){
			$this->Jccom($dir2.$file,$filepath);
			return $dir;
		}else{
			if(filemtime($dir2.$file) != filemtime($filepath)){
				$this->Jccom($dir2.$file,$filepath);
				return $dir;
			}else{
				return $dir;
			}
		}
	}
	
	private function Jccom($dir,$filepath){
		$temp = DuoLamBase::$config['frame']['mode']==1 ? DuoLam::url().'index.php/' : DuoLam::url();
		$css = file_get_contents($filepath);
		$css = preg_replace('/{view}/i',DuoLam::uview(),$css);
		$css = preg_replace('/{url}/i',DuoLam::url(),$css);
		$css = preg_replace('/{u}/i',$temp,$css);
		file_put_contents($dir,$css);
		@touch($dir,filemtime($filepath));
	}
	public function __destruct(){}
}
?>